package com.clx.performance.dao.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.OwnerAccountDao;
import com.clx.performance.mapper.OwnerAccountMapper;
import com.clx.performance.model.OwnerAccount;
import com.clx.performance.param.pc.PageOwnerAccountListParam;
import com.clx.performance.struct.OwnerAccountStruct;
import com.clx.performance.vo.pc.OwnerAccountVO;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public class OwnerAccountDaoImpl extends BaseDaoImpl<OwnerAccountMapper, OwnerAccount, Integer> implements OwnerAccountDao {

    @Autowired
    private OwnerAccountStruct ownerAccountStruct;

    @Override
    public IPage<OwnerAccountVO> pageList(PageOwnerAccountListParam param) {
        Page<OwnerAccountVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageList(page, param);

    }

    @Override
    public List<OwnerAccountVO> accountInfo(Long ownerUserNo) {
        List<OwnerAccount> list = baseMapper.selectList(lQrWrapper().eq(OwnerAccount::getOwnerUserNo, ownerUserNo));
        return ownerAccountStruct.convertList(list);
    }

    @Override
    public OwnerAccount getAccountByOwnerUserNoAndAccountType(Long ownerUserNo, Integer accountType) {
        return baseMapper.selectOne(lQrWrapper().eq(OwnerAccount::getAccountType, accountType).eq(OwnerAccount::getOwnerUserNo, ownerUserNo));
    }


}
