package com.clx.performance.controller.pc.owner;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.owner.OwnerConfirmSettlementParam;
import com.clx.performance.param.pc.owner.OwnerPaymentSettlementParam;
import com.clx.performance.param.pc.owner.PageOwnerSettlementOwnerDetailParam;
import com.clx.performance.service.settle.SettlementOwnerDetailService;
import com.clx.performance.service.settle.SettlementOwnerService;
import com.clx.performance.vo.pc.carrier.settle.CarrierSettlementOwnerDetailVO;
import com.clx.performance.vo.pc.owner.settle.PageOwnerSettlementOwnerDetailVO;
import com.clx.performance.vo.pc.owner.settle.SettlementPlatformAccountVO;
import com.clx.user.param.pc.driver.truck.PageDriverTruckParam;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;


@Slf4j
@RestController
@RequestMapping(value="/pc/owner/settlementOwner")
@Validated
@Api(tags = "货主端-货主结算")
@AllArgsConstructor
public class OwnerSettlementOwnerController {

    private final SettlementOwnerService settlementOwnerService;

    private final SettlementOwnerDetailService settlementOwnerDetailService;



    @ApiOperation(value = "结算单详情",notes = "<br>By:李瑞新")
    @GetMapping("/getOwnerSettlementOwnerDetail")
    @UnitCovert(param = false)
    public Result<CarrierSettlementOwnerDetailVO> getOwnerSettlementOwnerDetail(@NotNull(message = "id不能为空") Integer id) {
        return Result.ok(settlementOwnerService.getCarrierSettlementOwnerDetail(id));
    }


    @ApiOperation(value = "确认结算单接口",notes = "<br>By:李瑞新")
    @PostMapping("/updateConfirmSettlement")
    public Result updateConfirmSettlement(@RequestBody @Validated OwnerConfirmSettlementParam param) {
        settlementOwnerService.updateConfirmSettlement(param.getId());
        return Result.ok();
    }

    @ApiOperation(value = "获取结算平台收款账号",notes = "<br>By:李瑞新")
    @GetMapping("/getSettlementPlatformAccount")
    public Result<SettlementPlatformAccountVO> getSettlementPlatformAccount() {
        return Result.ok(settlementOwnerService.getSettlementPlatformAccount());
    }

    @ApiOperation(value = "付款接口",notes = "<br>By:李瑞新")
    @PostMapping("/updatePaymentSettlement")
    public Result updatePaymentSettlement(@RequestBody @Validated OwnerPaymentSettlementParam param) {
        settlementOwnerService.updatePaymentSettlement(param);
        return Result.ok();
    }


    @ApiOperation(value = "付款确认接口",notes = "<br>By:李瑞新")
    @PostMapping("/updatePaymentConfirmSettlement")
    public Result updatePaymentConfirmSettlement(@RequestBody @Validated OwnerConfirmSettlementParam param) {
        settlementOwnerService.updatePaymentConfirmSettlement(param.getId());
        return Result.ok();
    }

    @ApiOperation(value = "结算运单明细",notes = "<br>By:李瑞新")
    @PostMapping("/pageOwnerSettlementOrderDetailList")
    @UnitCovert(param = false)
    public Result<PageData<PageOwnerSettlementOwnerDetailVO>> pageOwnerSettlementOrderDetailList(@RequestBody @Validated PageOwnerSettlementOwnerDetailParam param) {
        IPage<PageOwnerSettlementOwnerDetailVO> page = settlementOwnerDetailService.pageOwnerSettlementOrderDetailList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @ApiOperation(value = "导出结算运单明细")
    @PostMapping("/exportOwnerSettlementOrderDetail")
    public Result exportOwnerSettlementOrderDetail(@RequestBody @Validated PageOwnerSettlementOwnerDetailParam param, HttpServletResponse response) throws Exception {

        SXSSFWorkbook workbook = settlementOwnerDetailService.exportOwnerSettlementOrderDetail(param);
        response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_OCTET_STREAM_VALUE);
        workbook.write(response.getOutputStream());
        return null;
    }


}
