package com.clx.performance.controller.pc.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.owner.PageCarrierSettlementOwnerDetailParam;
import com.clx.performance.service.settle.SettlementOwnerDetailService;
import com.clx.performance.vo.pc.carrier.settle.CarrierPageSettlementOwnerDetailVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/settlementOwnerDetail")
@Validated
@Api(tags = "承运端-计费管理")
@AllArgsConstructor
public class CarrierSettlementOwnerDetailController {

    private final SettlementOwnerDetailService settlementOwnerDetailService;


    @ApiOperation(value = "运单计费列表（货主）",notes = "<br>By:刘海泉")
    @GetMapping("/pageSettlementOwnerDetail")
    @UnitCovert(param = false)
    public Result<PageData<CarrierPageSettlementOwnerDetailVO>> pageSettlementOwnerDetail(@RequestBody @Validated PageCarrierSettlementOwnerDetailParam param) {
        IPage<CarrierPageSettlementOwnerDetailVO> page = settlementOwnerDetailService.pageSettlementOwnerDetail(param);
        return Result.page(page.getRecords(),page.getTotal(),page.getPages());
    }


}
