package com.clx.performance.controller.pc.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.owner.PageCarrierSettlementOwnerParam;
import com.clx.performance.service.settle.SettlementOwnerService;
import com.clx.performance.vo.pc.carrier.settle.CarrierPageSettlementOwnerVO;
import com.clx.performance.vo.pc.carrier.settle.CarrierSettlementOwnerDetailVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotNull;


@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/settlementOwner")
@Validated
@Api(tags = "承运端-货主结算")
@AllArgsConstructor
public class CarrierSettlementOwnerController {

    private final SettlementOwnerService settlementOwnerService;


    @ApiOperation(value = "结算单详情",notes = "<br>By:李瑞新")
    @GetMapping("/getCarrierSettlementOwnerDetail")
    @UnitCovert(param = false)
    public Result<CarrierSettlementOwnerDetailVO> getCarrierSettlementOwnerDetail(@NotNull(message = "id不能为空") Integer id) {
        return Result.ok(settlementOwnerService.getCarrierSettlementOwnerDetail(id));
    }



    @ApiOperation(value = "结算单列表（货主）",notes = "<br>By:刘海泉")
    @GetMapping("/pageCarrierSettlementOwner")
    @UnitCovert(param = false)
    public Result<PageData<CarrierPageSettlementOwnerVO>> pageCarrierSettlementOwner(@RequestBody @Validated PageCarrierSettlementOwnerParam param) {
        IPage<CarrierPageSettlementOwnerVO> page = settlementOwnerService.pageCarrierSettlementOwner(param);
        return Result.page(page.getRecords(),page.getTotal(),page.getPages());
    }


}
