package com.clx.performance.sdk.request.action;

import com.msl.common.convertor.type.MoneyInConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

import static com.clx.performance.sdk.constant.ActionConstants.ORDER_INFO_SYNC;

/**
 * @ClassName SyncOwnerInfoMessage
 * @Description  同步货主信息
 * @Author kavin
 * @Date 2023/10/13 14:39
 * @Version 1.0
 */

@Getter
@Setter
@Accessors(chain = true)
public class SyncOrderInfoAction implements Action<String>{
    @NotNull(message = "货主编号不能为空")
    @ApiModelProperty(value = "货主编号" ,required = true)
    private Long ownerUserNo;

    @NotBlank(message = "货主姓名不能为空")
    @ApiModelProperty(value = "货主姓名" ,required = true)
    private String ownerUserName;


    @NotNull(message = "拉运类型不能为空")
    @ApiModelProperty(value = "拉运类型 0单次拉运 1长期拉运" ,required = true)
    private Integer transportType;


    @ApiModelProperty(value = "长协合同编号")
    private String longTermContractNo;

    @NotBlank(message = "货物类型名称不能为空")
    @ApiModelProperty(value = "货物类型名称",required = true)
    private String goodsTypeName;


    @NotBlank(message = "货物名称货物名称不能为空")
    @ApiModelProperty(value = "货物名称",required = true)
    private String goodsName;

    @NotBlank(message = "货物型号不能为空")
    @ApiModelProperty(value = "货物型号",required = true)
    private String goodsModel;

    @NotNull(message = "拉运重量不能为空")
    @ApiModelProperty(value = "拉运重量（吨）",required = true)
    private BigDecimal transportWeight;

    @NotNull(message = "向下浮动量不能为空")
    @ApiModelProperty(value = "向下浮动量（吨）",required = true)
    private BigDecimal downFloatWeight;


    @ApiModelProperty(value = "向上浮动量（吨）")
    private BigDecimal upFloatWeight;

    @NotNull(message = "是否可超吨不能为空")
    @ApiModelProperty(value = "是否可超吨 0 否  1 是")
    private Integer overWeight;

    @NotNull(message = "损耗单价不能为空")
    @ApiModelProperty(value = "损耗单价(元)",required = true)
    @MoneyInConvert
    private BigDecimal lossPrice;


    @NotBlank(message = "联系人不能为空")
    @ApiModelProperty(value = "联系人（货主方）",required = true)
    private String contactOwner;

    @NotBlank(message = "联系电话不能为空")
    @ApiModelProperty(value = "联系电话（货主方)",required = true)
    private String contactPhoneOwner;

    @NotBlank(message = "发货地省不能为空")
    @ApiModelProperty(value = "发货地省",example = "北京省")
    private String sendProvince;

    @NotBlank(message = "发货地市不能为空")
    @ApiModelProperty(value = "发货地市",example = "北京市")
    private String sendCity;

    @NotBlank(message = "发货地区县不能为空")
    @ApiModelProperty(value = "发货地区县",example = "西城区")
    private String sendCounty;

    @NotBlank(message = "发货地详细地址不能为空")
    @ApiModelProperty(value = "发货地详细地址",example = "黄寺大街26号楼六号院")
    private String sendAddress;


    @NotBlank(message = "发货-地址简称不能为空")
    @ApiModelProperty(value = "发货-地址简称",required = true)
    private String sendAddressShorter;


    @NotBlank(message = "场地类型不能为空")
    @ApiModelProperty(value = "场地类型",example = "集运站")
    private String sendSiteType;

    @NotBlank(message = "联系人不能为空")
    @ApiModelProperty(value = "联系人",example = "李四")
    private String sendContact;

    @NotBlank(message = "联系电话不能为空")
    @ApiModelProperty(value = "联系电话",example = "12222222222")
    private String sendContactPhone;

    @ApiModelProperty(value = "地址规则",example = "这就是规则")
    private String sendAddressRule;


    @NotNull(message = "经度不能为空")
    @ApiModelProperty(value = "经度",example = "112.23")
    private BigDecimal sendLongitude;

    @NotNull(message = "纬度不能为空")
    @ApiModelProperty(value = "纬度",example = "36.23")
    private BigDecimal sendLatitude;




    @ApiModelProperty(value = "发货-是否可超标准  0 否  1 是")
    private Integer sendOverStandard;


    @ApiModelProperty(value = "发货-预估装车时长(小时)")
    private BigDecimal sendEstimatedLoadingTime;


    @ApiModelProperty(value = "发货-是否需要系统排队 0 否  1 是")
    private Integer sendWaitSystem;


    @ApiModelProperty(value = "发货-排队系统名称")
    private String sendWaitSystemName;


    @ApiModelProperty(value = "发货-预估排队时长")
    private BigDecimal sendEstimatedWaitTime;

    @NotNull(message = "发货-煤源生产情况不能为空")
    @ApiModelProperty(value="发货-煤源生产情况 1 现产现装  2 存煤",required = true)
    private Integer sendCoalSourceProductSituation;


    @ApiModelProperty(value="发货-现产现装效率(车/小时)")
    private BigDecimal sendProductLoadEfficiency;

    @NotNull(message = "发货-司机到达货源地范围不能为空")
    @ApiModelProperty(value="发货-司机到达货源地范围(千米)",required = true)
    private BigDecimal sendDriverArriveRange;


    @ApiModelProperty(value="发货-过磅费(元)")
    @MoneyInConvert
    private BigDecimal sendPoundFee;


    @ApiModelProperty(value="发货-其他过磅费(元)")
    @MoneyInConvert
    private BigDecimal sendOtherPoundFee;


    @ApiModelProperty(value="发货-装卸费(元)")
    @MoneyInConvert
    private BigDecimal sendLoadFee;


    @ApiModelProperty(value="发货-其他装卸费(元)")
    @MoneyInConvert
    private BigDecimal sendOtherLoadFee;


    @ApiModelProperty(value="发货-其他费用  数据样例： [{'fee':500,'remark':'其他费用备注'}]")
    private String sendOtherFee;

    @NotNull(message = "发货-货源地开支金额起不能为空")
    @ApiModelProperty(value="发货-货源地开支金额起(元)",required = true)
    @MoneyInConvert
    private BigDecimal sendPayFeeBegin;

    @NotNull(message = "发货-货源地开支金额止不能为空")
    @ApiModelProperty(value="发货-货源地开支金额止(元)",required = true)
    @MoneyInConvert
    private BigDecimal sendPayFeeEnd;


    @NotBlank(message = "收货地省不能为空")
    @ApiModelProperty(value = "收货地省",example = "北京省")
    private String reveiveProvince;

    @NotBlank(message = "收货地市不能为空")
    @ApiModelProperty(value = "收货地市",example = "北京市")
    private String reveiveCity;

    @NotBlank(message = "收货地区县不能为空")
    @ApiModelProperty(value = "收货地区县",example = "西城区")
    private String reveiveCounty;

    @NotBlank(message = "收货地详细地址不能为空")
    @ApiModelProperty(value = "收货地详细地址",example = "黄寺大街26号楼六号院")
    private String reveiveAddress;

    @NotBlank(message = "收货-地址简称不能为空")
    @ApiModelProperty(value="收货-地址简称",required = true)
    private String reveiveAddressShorter;

    @NotBlank(message = "场地类型不能为空")
    @ApiModelProperty(value = "场地类型",example = "集运站")
    private String reveiveSiteType;

    @NotBlank(message = "联系人不能为空")
    @ApiModelProperty(value = "联系人",example = "李四")
    private String reveiveContact;

    @NotBlank(message = "联系电话不能为空")
    @ApiModelProperty(value = "联系电话",example = "12222222222")
    private String reveiveContactPhone;

    @ApiModelProperty(value = "地址规则",example = "这就是规则")
    private String reveiveAddressRule;


    @NotNull(message = "经度不能为空")
    @ApiModelProperty(value = "经度",example = "112.23")
    private BigDecimal reveiveLongitude;

    @NotNull(message = "纬度不能为空")
    @ApiModelProperty(value = "纬度",example = "36.23")
    private BigDecimal reveiveLatitude;



    //@NotNull(message = "收货-是否可超标准不能为空")
    @ApiModelProperty(value="收货-是否可超标准  0 否  1 是")
    private Integer reveiveOverStandard;


    @ApiModelProperty(value="收货-预估卸车时长(小时)")
    private BigDecimal reveiveEstimatedUnLoadingTime;


    @ApiModelProperty(value="收货-是否需要系统排队 0 否  1 是")
    private Integer reveiveWaitSystem;


    @ApiModelProperty(value="收货-排队系统名称")
    private String reveiveWaitSystemName;

    @NotNull(message = "收货-司机到达目的地范围不能为空")
    @ApiModelProperty(value="收货-司机到达目的地范围(千米)",required = true)
    private BigDecimal reveiveDriverArriveRange;


    @ApiModelProperty(value="收发地磅差")
    private BigDecimal reveivePoundDiff;


    @ApiModelProperty(value="收货-过磅费(元)")
    @MoneyInConvert
    private BigDecimal reveivePoundFee;


    @ApiModelProperty(value="收货-其他过磅费(元)")
    @MoneyInConvert
    private BigDecimal reveiveOtherPoundFee;


    @ApiModelProperty(value="收货-装卸费(元)")
    @MoneyInConvert
    private BigDecimal reveiveLoadFee;


    @ApiModelProperty(value="收货-其他装卸费(元)")
    @MoneyInConvert
    private BigDecimal reveiveOtherLoadFee;


    @ApiModelProperty(value="收货-其他费用 数据样例： [{'fee':500,'remark':'其他费用备注'}]")
    private String reveiveOtherFee;


    @ApiModelProperty(value="收货-收货地开支金额起(元)")
    @MoneyInConvert
    private BigDecimal reveivePayFeeBegin;


    @ApiModelProperty(value="收货-收货地开支金额止(元)")
    @MoneyInConvert
    private BigDecimal reveivePayFeeEnd;

    @NotNull(message = "用车需求不能为空")
    @ApiModelProperty(value = "用车需求： 1平台车辆",required = true)
    private Integer truckDemand;


    @ApiModelProperty("平台承运吨数")
    private BigDecimal platformCarryWeight;


    @ApiModelProperty(value = "自有车辆(辆)")
    private Integer ownerTruckNumber;

    @ApiModelProperty(value = "车型要求列表json",example = "['重型半挂牵引车','重型厢式半挂车']")
    private String truckModelList;

    @NotNull(message = "拉运开始时间不能为空")
    @ApiModelProperty(value = "拉运开始时间",required = true,example = "2023-09-13 12:23:03")
    private String transportBeginTime;

    @NotNull(message = "拉运结束时间不能为空")
    @ApiModelProperty(value = "拉运结束时间",required = true,example = "2023-09-13 12:23:03")
    private String transportEndTime;

    @NotBlank(message = "可装车时间段开始不能为空")
    @ApiModelProperty(value="可装车时间段开始",required = true,example = "08:13:29")
    private String loadBeginTime;

    @NotBlank(message = "可装车时间段结束不能为空")
    @ApiModelProperty(value="可装车时间段结束",required = true,example = "08:13:29")
    private String loadEndTime;

    @NotBlank(message = "可卸车时间段开始不能为空")
    @ApiModelProperty(value="可卸车时间段开始",required = true,example = "08:13:29")
    private String unloadBeginTime;

    @NotBlank(message = "可卸车时间段结束不能为空")
    @ApiModelProperty(value="可卸车时间段结束",required = true,example = "08:13:29")
    private String unloadEndTime;


    @ApiModelProperty(value="意向运费(元)")
    @MoneyInConvert
    private BigDecimal intentionFreightPrice;

    @Override
    public String action() {
        return ORDER_INFO_SYNC;
    }
}
