package com.clx.performance.sdk.request;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.clx.performance.sdk.request.action.Action;
import com.google.gson.Gson;
import com.msl.common.dto.HttpDTO;
import com.msl.common.result.Result;
import com.msl.common.utils.EncryptUtil;
import com.msl.common.utils.HttpUtil;
import lombok.extern.slf4j.Slf4j;

/**
 * @author wanglq
 * Date 2023/8/5
 * Time 16:50
 */
@Slf4j
public class PerformanceRequestClient {
    private String gatewayUrl;
    private String appNo;
    private String appSecret;

    public PerformanceRequestClient(String gatewayUrl, String appNo, String appSecret) {
        this.gatewayUrl = gatewayUrl;
        this.appNo = appNo;
        this.appSecret = appSecret;
    }


    public <T> Result<T> doAction(Action<T> action) {
        try {
            HttpDTO httpDTO = EncryptUtil.buildDTO(appNo, JSON.toJSONString(action), appSecret, System.currentTimeMillis());
            httpDTO.setAction(action.action());
            return HttpUtil.post(gatewayUrl, null,
                            httpDTO)
                    .map(r -> JSON.parseObject(r, new TypeReference<HttpDTO>() {
                    }))
                    .mapTry(dto -> EncryptUtil.decrypt(dto.getData(), appSecret))
                    .mapWithObj(new TypeReference<Result<T>>() {
                    }, this::covertResult)
                    .get();
        } catch (Exception e) {
            throw new RuntimeException("http请求失败", e);
        }
    }

    private <T> Result<T> covertResult(String result, TypeReference<Result<T>> reference) {
        return new Gson().fromJson(result, reference.getType());
    }
}
