package com.clx.performance.sdk.callback.message;

import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import java.math.BigDecimal;

import static com.clx.performance.sdk.constant.MessageConstants.ORDER_CHILD_INFO_SYNC;


@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Builder
@EqualsAndHashCode
public class OrderChildMessage implements Message{

    @ApiModelProperty(value = "运单编号", example = "100000000")
    private String childNo;

    @ApiModelProperty(value = "运费单价(分)", example = "1.23")
    private BigDecimal freightPrice;

    @ApiModelProperty(value = "车牌号", example = "京A12345")
    private String truckNo;

    @ApiModelProperty(value="司机姓名",example = "张安")
    private String driverName;

    @ApiModelProperty(value="司机手机号",example = "12222222222")
    private String driverMobile;

    @ApiModelProperty("运单状态：10：已接单  30：前往货源地 40：到达货源地 50：装货成功 60：前往目的地 70：到达目的地 80：收货待确认")
    private Integer status;

    @ApiModelProperty(value="接单时间",example = "2020-01-01 10:10:10")
    private String payTime;

    @ApiModelProperty(value="装车时间",example = "2020-01-01 10:10:10")
    private String loadTime;

    @ApiModelProperty(value="装货净重",example = "10")
    private BigDecimal loadNet;

    @ApiModelProperty(value="卸车时间",example = "2020-01-01 10:10:10")
    private String unloadTime;

    @ApiModelProperty(value="卸货净重",example = "41")
    private BigDecimal unloadNet;

    @Override
    public String topic() {
        return ORDER_CHILD_INFO_SYNC;
    }
}
