package com.clx.performance.vo.pc;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 货主提现;
 *
 * @date : 2023-10-12
 */

@Getter
@Setter
@NoArgsConstructor
public class OwnerCaseOutVO {
    /**
     * id
     */
    @ApiModelProperty(value = "id")
    private Integer id;

    /**
     * 货主编号
     */
    @ApiModelProperty(value = "货主编号")
    private Long ownerUserNo;

    /**
     * 提现编号
     */
    @ApiModelProperty(value = "提现编号")
    private Long caseOutNo;
    /**
     * 提现账户类型
     */
    @ApiModelProperty(value = "提现账户类型 1 ：保证金 2：预付运费")
    private Integer accountType;
    /**
     * 提现金额
     */
    @ApiModelProperty(value = "提现金额")
    @MoneyOutConvert
    private BigDecimal caseOutBalance;
    /**
     * 状态
     */
    @ApiModelProperty(value = "状态 10：代付款 20：待货主确认 30：已付款")
    private Integer status;
    /**
     * 提现银行
     */
    @ApiModelProperty(value = "提现银行")
    private String caseOutBank;
    /**
     * 提现银行卡号
     */
    @ApiModelProperty(value = "提现银行卡号")
    private String caseOutBankNumber;
    /**
     * 操作人
     */
    @ApiModelProperty(value = "操作人")
    private String createBy;
    /**
     * 付款时间
     */
    @ApiModelProperty(value = "付款时间")
    private LocalDateTime paymentTime;
    /**
     * 平台付款银行
     */
    @ApiModelProperty(value = "平台付款银行")
    private String platformPaymentBank;
    /**
     * 平台付款银行账号
     */
    @ApiModelProperty(value = "平台付款银行账号")
    private String platformPaymentBankNumber;
    /**
     * 付款人
     */
    @ApiModelProperty(value = "付款人")
    private String paymentBy;
    /**
     * 付款凭证
     */
    @ApiModelProperty(value = "付款凭证")
    private String paymentProof;
    /**
     * 创建时间
     */
    @ApiModelProperty(value = "操作时间")
    private LocalDateTime createTime;
    /**
     * 修改时间
     */
    @ApiModelProperty(value = "修改时间")
    private LocalDateTime modifyTime;

}