package com.clx.performance.param.pc;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;


@ApiModel(description = "货主充值")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class OwnerTopUpParam {

    @ApiModelProperty(value = "货主用户编号", example = "123")
    private Long ownerUserNo;

    @ApiModelProperty(value = "充值金额（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal topUpBalance;

    @ApiModelProperty(value = "账户类型： 1：保证金 2：预付运费", example = "1")
    private Integer accountType;

    @ApiModelProperty(value = "打款银行", example = "浙江银行")
    private String drawingBank;

    @ApiModelProperty(value = "打款银行卡号", example = "62213545878787")
    private String drawingBankNumber;

    @ApiModelProperty(value = "打款凭证", example = "/a.png")
    private String drawingProof;



}