package com.clx.performance.controller.feign;

import com.clx.performance.service.OrderGoodsService;
import com.clx.performance.vo.feign.OrderGoodsFeignVO;
import io.swagger.annotations.Api;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotNull;
import java.util.List;

@RestController
@RequestMapping("/feign/orderGoods")
@Validated
@Api(tags = "货单Feign")
@AllArgsConstructor
public class OrderGoodsFeignController {

    private final OrderGoodsService orderGoodsService;

    @GetMapping({"/getOrderGoodsListByOrderNo"})
    List<OrderGoodsFeignVO> getOrderGoodsListByOrderNo(@RequestParam("userNo") @NotNull(message = "订单编号不可为空") String orderNo) {
        return orderGoodsService.getOrderGoodsListByOrderNo(orderNo);
    }
}
