package com.clx.performance.config;

import com.clx.performance.constant.RabbitKeyOrderChildConstants;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author: aiqingguo
 * @Description: 运单 MQ
 * @Date: 2023-10-12 16:27:30
 * @Version: 1.0
 */
@Configuration
public class RabbitOrderChildConfig {

    @Bean
    public DirectExchange orderChildDefaultExchange() {
        return new DirectExchange(RabbitKeyOrderChildConstants.DEFAULT_EXCHANGE);
    }

    @Bean
    public Queue orderChildDefaultDelayQueue() {
        Map<String, Object> params = new HashMap<>(8);
        params.put("x-message-ttl", 15 * 60 * 1000);
        params.put("x-max-length", 5000000);
        params.put("x-dead-letter-exchange", RabbitKeyOrderChildConstants.DEFAULT_EXCHANGE);
        params.put("x-dead-letter-routing-key", RabbitKeyOrderChildConstants.DEFAULT_DEAD_ROUTING_KEY);
        return new Queue(RabbitKeyOrderChildConstants.DEFAULT_DELAY_QUEUE, true, false, false, params);
    }
    @Bean
    public Binding orderChildDefaultDelayQueueBinding() {
        return BindingBuilder.bind(orderChildDefaultDelayQueue()).to(orderChildDefaultExchange()).with(RabbitKeyOrderChildConstants.DEFAULT_DELAY_ROUTING_KEY);
    }

    @Bean
    public Queue orderChildDefaultDeadQueue() {
        return new Queue(RabbitKeyOrderChildConstants.DEFAULT_DEAD_QUEUE);
    }
    @Bean
    public Binding orderChildDefaultDeadQueueBinding() {
        return BindingBuilder.bind(orderChildDefaultDeadQueue()).to(orderChildDefaultExchange()).with(RabbitKeyOrderChildConstants.DEFAULT_DEAD_ROUTING_KEY);
    }


    /**
     * 新增
     */
    @Bean
    public Queue orderChildAddQueue() {
        return new Queue(RabbitKeyOrderChildConstants.ORDER_CHILD_ADD_QUEUE);
    }
    @Bean
    public Binding orderChildAddQueueBinding() {
        return BindingBuilder.bind(orderChildAddQueue()).to(orderChildDefaultExchange()).with(RabbitKeyOrderChildConstants.ORDER_CHILD_ADD_ROUTING_KEY);
    }

    /**
     * 司机确认收货
     */
    @Bean
    public Queue orderChildDriverConfirmQueue() {
        return new Queue(RabbitKeyOrderChildConstants.ORDER_CHILD_DRIVER_CONFIRM_QUEUE);
    }
    @Bean
    public Binding orderChildDriverConfirmQueueBinding() {
        return BindingBuilder.bind(orderChildDriverConfirmQueue()).to(orderChildDefaultExchange()).with(RabbitKeyOrderChildConstants.ORDER_CHILD_DRIVER_CONFIRM_ROUTING_KEY);
    }


}
