package com.clx.performance;

import com.clx.order.enums.OrderEnum;
import com.clx.order.feign.OrderFeign;
import com.clx.order.param.feign.UpdateOrderInfoParam;
import com.clx.order.param.feign.UpdateOrderInfoResidueWeightParam;
import com.clx.order.vo.feign.FeignOrderVO;
import com.clx.order.vo.feign.OrderOwnTruckVo;
import com.clx.performance.component.OrderGoodsStatusLazyComponent;
import com.clx.performance.constant.RabbitKeyConstants;
import com.clx.performance.constant.RedisConstants;
import com.clx.performance.dao.OrderGoodsDao;
import com.clx.performance.dao.OwnerAccountDao;
import com.clx.performance.dao.OwnerCaseOutDao;
import com.clx.performance.enums.OrderGoodsStatusEnum;
import com.clx.performance.enums.OrderGoodsTruckBindEnum;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.feign.PerformanceFeign;
import com.clx.performance.mapper.OrderGoodsMapper;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.model.OwnerAccount;
import com.clx.performance.model.OwnerCaseOut;
import com.clx.performance.param.pc.OwnerCaseOutParam;
import com.clx.performance.param.pc.owner.FrozenAccountParam;
import com.clx.performance.service.OwnerAccountService;
import com.msl.common.base.Optional;
import com.msl.common.exception.ServiceSystemException;
import com.msl.common.result.Result;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.test.context.junit4.SpringRunner;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@SpringBootTest
@RunWith(SpringRunner.class)
public class JobTest {

    @Autowired
    private OrderFeign orderFeign;

    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Autowired
    private OrderGoodsStatusLazyComponent orderGoodsStatusLazyComponent;

    @Autowired
    private OrderGoodsDao orderGoodsDao;

    @Autowired
    private OwnerAccountDao ownerAccountDao;

    @Autowired
    private OwnerAccountService ownerAccountService;

    @Autowired
    private PerformanceFeign performanceFeign;

    @Autowired
    private OwnerCaseOutDao ownerCaseOutDao;

    @Test
    public void test1() {
        Optional<OwnerCaseOut> optional = ownerCaseOutDao.getEntityByKey(19);
        OwnerCaseOut ownerCaseOut = optional.get();
        BigDecimal caseOutBalance = ownerCaseOut.getCaseOutBalance();
        BigDecimal platformPayBalance = ownerCaseOut.getPlatformPayBalance();
        if (platformPayBalance.compareTo(caseOutBalance) != 0) {
            throw new ServiceSystemException(PerformanceResultEnum.MONEY_NO_SAME);
        }
    }
}
