package com.clx.performance.sqlProvider;

import cn.hutool.core.util.ObjectUtil;
import com.clx.performance.param.pc.PageOwnerAccountListParam;
import com.clx.performance.param.pc.PageOwnerTopUpListParam;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

public class OwnerTopUpProvider {

    public String ownerTopUpPageList(@Param("param") PageOwnerTopUpListParam param) {
        String sql = new SQL() {{
            SELECT("a.id, a.owner_user_no," +
                    " a.top_up_no, a.top_up_balance, a.account_type, " +
                    " a.status,a.drawing_bank, a.drawing_bank_number,a.drawing_proof,a.approval_time,a.approval_by,a.approval_turn_down,a.create_by,date_format(a.create_time, '%Y-%m-%d %H:%i:%s') as create_time,a.modified_time");
            FROM("owner_top_up a");
            if (StringUtils.isNotBlank(param.getBeginTime()) && StringUtils.isNotBlank(param.getEndTime())) {
                WHERE("a.create_time >= #{param.beginTime} and a.create_time <= #{param.endTime}");
            }
            if (ObjectUtil.isNotNull(param.getAccountType())) {
                WHERE("a.account_type = #{param.accountType}");
            }
            if (ObjectUtil.isNotNull(param.getOwnerUserNo())) {
                WHERE("a.owner_user_no = #{param.ownerUserNo}");
            }
            ORDER_BY("a.create_time desc");
        }}.toString();
        return sql;
    }

}
