package com.clx.performance.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.model.OwnerAccount;
import com.clx.performance.param.pc.PageOwnerAccountListParam;
import com.clx.performance.sqlProvider.OwnerAccountSqlProvider;
import com.clx.performance.vo.pc.OwnerAccountVO;
import com.msl.common.utils.DateUtils;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 货主账户
 */
@Mapper
public interface OwnerAccountMapper extends BaseMapper<OwnerAccount> {

    @SelectProvider(type = OwnerAccountSqlProvider.class, method = "pageList")
    IPage<OwnerAccountVO> pageList(Page<OwnerAccountVO> page, PageOwnerAccountListParam param);

    //    @SelectProvider(type = OwnerAccountSqlProvider.class, method = "addAccount")
    @Update("update owner_account set usable_balance = usable_balance + #{account.usableBalance}"
            + ",account_balance = account_balance + #{account.accountBalance}"
            + ",modified_time= #{now}"
            + "where id = #{account.id} and modified_time = #{account.modifiedTime}"
    )
    Integer addAccount(@Param("account") OwnerAccount account, @Param("now") String now);

    @Update("update owner_account set usable_balance = usable_balance - #{account.usableBalance}," +
            "frozen_balance = frozen_balance + #{account.frozenBalance},account_balance = account_balance - #{account.accountBalance}," +
            "modified_time=#{now}"
            + "where id = #{account.id} and modified_time = #{account.modifiedTime}"
    )
    Integer subAccount(@Param("account") OwnerAccount account, @Param("now") String now);

    @Update("update owner_account set frozen_balance = frozen_balance - #{account.frozenBalance}," +
            "modified_time=#{now}"
            + "where id = #{account.id} and modified_time = #{account.modifiedTime}"
    )
    Integer updateOwnerAccountForConfirm(@Param("account") OwnerAccount account, @Param("now") String now);
}