package com.clx.performance.dao.settle;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.mapper.settle.SettlementOwnerDetailMapper;
import com.clx.performance.model.settle.SettlementOwnerDetail;
import com.clx.performance.param.pc.owner.PageCarrierSettlementOwnerDetailParam;
import com.clx.performance.param.pc.owner.PageOwnerSettlementOwnerDetailParam;
import com.msl.common.base.Optional;
import com.msl.common.dao.BaseDao;

import java.util.List;


/**
 * @Author: aiqinguo
 * @Description: 货主运单计费明细
 * @Date: 2023-10-11 18:00:53
 * @Version: 1.0
 */
public interface SettlementOwnerDetailDao extends BaseDao<SettlementOwnerDetailMapper, SettlementOwnerDetail, Integer> {

    boolean updateInvoiceType(SettlementOwnerDetail item);
    boolean updateSettlementNo(SettlementOwnerDetail item);

    Optional<SettlementOwnerDetail> getByChildNo(String childNo);
    List<SettlementOwnerDetail> getBySettlementNo(String settlementNo);

    IPage<SettlementOwnerDetail> pageOwnerSettlementOrderDetailList(PageOwnerSettlementOwnerDetailParam param);

    IPage<SettlementOwnerDetail> pageSettlementOwnerDetail(PageCarrierSettlementOwnerDetailParam param);
}
