package com.clx.performance.controller.system;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.registry.NacosRegistration;
import com.alibaba.cloud.nacos.registry.NacosServiceRegistry;
import com.msl.common.result.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 应用服务器控制
 *
 * @author wanglq
 * Date 2022/11/28
 * Time 15:43
 */
@RestController
@RequestMapping("/appServer")
@Slf4j
public class AppServerController {
    @Autowired
    private NacosRegistration registration;
    @Autowired
    private NacosServiceRegistry registry;

    /**
     * 下线服务
     *
     * @return
     */
    @GetMapping("/deregister")
    public Result<Void> deregister() {
        NacosDiscoveryProperties properties = registration.getNacosDiscoveryProperties();
        String service = properties.getService();
        String group = properties.getGroup();
        String clusterName = properties.getClusterName();
        String ip = properties.getIp();
        int port = properties.getPort();
        log.info("deregister from nacos, serviceName:{}, groupName:{}, clusterName:{}, ip:{}, port:{}", service, group, clusterName, ip, port);
        registry.deregister(registration);
        return Result.ok();
    }

    /**
     * 应用状态
     *
     * @return
     */
    @GetMapping("/status")
    public Result<String> status() {
        return Result.ok("up");
    }
}
